/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

/*
 * definitions used for attribute management
 */

#ifndef _ATTRIB_H_
#define _ATTRIB_H_

/*
 * Structure holding an attribute value
 */
struct mx_attr {
    char *name;		/* null-terminated name of attribute */
    void   *value;	/* value of attribute */
    uint32_t len;	/* length of attribute value in bytes */

	/* address of handlers to call when a system attribute is accessed */
    mx_return_t (*set_handler)(void *, uint32_t);
    mx_return_t (*get_handler)(uint8_t *, void *, uint32_t *);

    struct mx_attr *next;	/* attributes are in a linked list */
};

#endif /* _ATTRIB_H_ */
